/* eslint-disable no-console */
/* eslint-disable no-plusplus */
/* eslint-disable prefer-destructuring */
/* eslint-disable no-else-return */
/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
/* eslint-disable no-undef */
/* eslint-disable no-unused-vars */


class QueryManager {
	constructor(dataclass, gridmanager, formmanager, $queryDisplay, $queryToolBar, errorManager) {
		this.$queryDisplay = $queryDisplay;
		this.$queryRowElem = $queryDisplay.find('.queryHolder');
		this.gridmanager = gridmanager;
		this.formmanager = formmanager;
		this.errorManager = errorManager;
		this.dataclass = dataclass;
		this.$queryInput = $queryDisplay.find('.queryAdvancedInput');
		this.$queryPlanResult = this.$queryRowElem.find('.queryResultContent.queryPlan');
		this.$queryPathResult = this.$queryRowElem.find('.queryResultContent.queryPath');
		this.$queryInput.on('change', this.handleQueryChange.bind(this));
		this.$queryRowElem.on('mousemouve', this.handleMouseMove.bind(this));
		this.$queryRowElem.on('mouseover', this.handleMouseOver.bind(this));
		this.$queryRowElem.on('mouseout', this.handleMouseOut.bind(this));
		this.nextBlockID = 0;
		this.curOverBlockID = -1;
		this.curOverBlock = null;
		this.$expandButton = $queryDisplay.find('.expanderButton');
		this.$expandButton.on('click', this.handleExpand.bind(this));
		this.$queryToolBar = $queryToolBar;
		this.$queryToolBar.tooltip();
		this.$queryToolBar.on('click', '.queryBarButton', this.handleQueryBarButton.bind(this));
		this.$queryTypeAtts = this.$queryToolBar.find('.queryTypeAtts');
		this.$queryTypeExpr = this.$queryToolBar.find('.queryTypeExpr');
		this.$queryTypeAtts.addClass('selected');
		this.$queryAdvancedHolder = $queryDisplay.find('.queryAdvancedHolder');
		this.$queryHolder = $queryDisplay.find('.queryHolder');
		this.$queryInputsBarHolder = $queryDisplay.find('.queryInputsBarHolder');
		this.$queryAdvancedHolder.hide();
		this.$queryHolder.hide();
		this.$queryAdvancedHolder.removeClass('hidden');
		this.expanded = false;
		this.queryHandler = null;
		this.isAdvancedQuery = false;
		this.lastQueries = [];
		this.lastQuery = '';
		this.loadSettings();
		if (this.expanded) {
			this.handleExpand(null, true);
		}
		if (this.isAdvancedQuery) {
			this.handleQueryBarButton({ currentTarget: this.$queryTypeExpr }, true);
		}

		if (this.lastQuery != null && this.lastQuery !== '') {
			this.$queryInput.val(this.lastQuery);
			if (this.isAdvancedQuery)
				this.runQuery(this.lastQuery);
		}

		// this.$queryInput.autocomplete({source:this.lastQueries});
		this.historyMenuInited = false;
		this.installHistoryMenu();

		if (!this.isAdvancedQuery)
			this.gridmanager.performQueryFromFooter();
	}

	loadSettings() {
		const settings = SettingManager.getProperty('QueryManager.advancedQuery', this.dataclass);
		if (settings != null) {
			this.isAdvancedQuery = settings.isOn === true;
			if (settings.isExpanded == null)
				this.expanded = true;
			else
				this.expanded = settings.isExpanded === true;
			if (settings.queryStack != null) {
				this.lastQueries = settings.queryStack.lastQueries;
				this.lastQuery = settings.queryStack.lastQuery;
			}
		}
	}

	saveSettings() {
		console.info(this);
	}

	
	saveQuery(queryText) {
		if (queryText != null) {
			this.lastQuery = queryText;
			const queryToSave = queryText.trim();
			if (queryToSave.length !== 0) {
				let found = false;
				this.lastQueries.forEach(queryStr => { found = found || queryStr === queryToSave; });
				if (!found) {
					if (this.lastQueries.length >= 20)
						this.lastQueries.splice(0, 1);
					this.lastQueries.push(queryToSave);
					this.installHistoryMenu();
				}
			}
		}
		SettingManager.setProperty('QueryManager.advancedQuery.queryStack', { lastQueries: this.lastQueries, lastQuery: this.lastQuery }, this.dataclass);
	}

	setQueryHandler(queryHandler) {
		this.queryHandler = queryHandler;
	}

	installHistoryMenu() {
		const menu = [];
		this.lastQueries.reverse().forEach((qstr, i) => {
			menu.push({ title: qstr, cmd: `${i}` });
		});
		if (this.historyMenuInited) {
			this.$queryDisplay.contextmenu('replaceMenu', menu);
		} else {
			this.historyMenuInited = true;

			this.$queryDisplay.contextmenu({
				delegate: '.queryAdvancedInput',
				menu,
				select: this.handleHistoryMenu.bind(this),
			});
		}
	}

	handleHistoryMenu(event, ui) {
		// eslint-disable-next-line radix
		const n = parseInt(ui.cmd);
		this.$queryInput.val(this.lastQueries[n]);
		this.handleQueryChange();
	}

	handleQueryBarButton(event, comesFromInit = false) {
		const manager = this;
		const $target = $(event.currentTarget);
		if ($target.hasClass('queryTypeAtts')) {
			this.$queryTypeExpr.removeClass('selected');
			$target.addClass('selected');
			this.$queryAdvancedHolder.hide();
			this.$queryHolder.hide();
			this.$queryInputsBarHolder.show();
			this.isAdvancedQuery = false;
			this.gridmanager.performQueryFromFooter();
			SettingManager.setProperty('QueryManager.advancedQuery.isOn', false, this.dataclass);
		} else if ($target.hasClass('queryTypeExpr')) {
			this.$queryTypeAtts.removeClass('selected');
			$target.addClass('selected');
			this.$queryInputsBarHolder.hide();
			this.$queryAdvancedHolder.show();
			this.$queryHolder.show();
			this.isAdvancedQuery = true;
			SettingManager.setProperty('QueryManager.advancedQuery.isOn', true, this.dataclass);
			if (!comesFromInit)
				this.handleQueryChange();
		} else if ($target.hasClass('queryClear')) {
			if (this.isAdvancedQuery) {
				this.$queryInput.val('');
				this.saveQuery('');
				this.handleQueryChange();
			} else {
				this.gridmanager.clearQueryInputs();
				this.gridmanager.performQueryFromFooter();

			}
		}
	}

	handleExpand(event, expandNow = false) {
		if (this.expanded && !expandNow) {
			this.expanded = false;
			this.$expandButton.addClass('collapsed');
			this.$expandButton.removeClass('expanded');
			this.$queryRowElem.addClass('hiddenQueryResult');
			this.$queryRowElem.removeClass('visibleQueryResult');
			SettingManager.setProperty('QueryManager.advancedQuery.isExpanded', false, this.dataclass);
			setTimeout(() => {
				this.gridmanager.resizeCanvas();
			}, 200);
			
		} else {
			this.expanded = true;
			this.$expandButton.removeClass('collapsed');
			this.$expandButton.addClass('expanded');
			this.$queryRowElem.removeClass('hiddenQueryResult');
			this.$queryRowElem.addClass('visibleQueryResult');
			SettingManager.setProperty('QueryManager.advancedQuery.isExpanded', true, this.dataclass);
		}
	}

	handleMouseOut() {
		this.deselectCurBlock();
	}

	handleMouseOver(event) {
		this.selectBlock(event);
	}

	handleMouseMove(event) {
		this.selectBlock(event);
	}

	deselectCurBlock() {
		if (this.curOverBlock != null) {
			// this.curOverBlock.prop('title', null);
			this.curOverBlock.removeAttr('title');
			this.curOverBlock.removeClass('overBlockInfo');
			this.curOverBlock = null;
			this.curOverBlockID = -1;
		}
	}

	selectBlock(event) {
		let elements = this.$queryPlanResult.find('.queryPlanBlock:hover').get();
		if (elements.length === 0)
			elements = this.$queryPathResult.find('.queryPlanBlock:hover').get();
		if (elements.length > 0) {
			const elem = elements[elements.length - 1];
			if (elem.id !== this.curOverBlockID) {
				this.deselectCurBlock();
				this.curOverBlock = $(elem);
				const tipstr = elem.getAttribute('data-tipstr');
				if (tipstr != null)
					this.curOverBlock.prop('title', tipstr);
				this.curOverBlock.addClass('overBlockInfo');
				this.curOverBlockID = elem.id;
			}
		} else {
			this.deselectCurBlock();
		}
	}

	destroy() {
		this.$queryInput.off();
		this.gridmanager = null;
		this.formmanager = null;
		this.$queryRowElem.off();
		this.$expandButton.off();
		this.$queryToolBar.off();
	}

	handleQueryChange() {
		const queryText = this.$queryInput.val();
		/* if (queryText !== '') { */
		this.runQuery(queryText);
		/* } */
	}

	getNextBlockID() {
		++this.nextBlockID;
		return `QueryPlanBlock${this.nextBlockID}`;
	}

	async runQuery(queryText) {
		const querySettings = { queryPlan: true, queryPath: true };
		let progress = null;
		if (this.gridmanager != null) {
			const filterAtts = this.gridmanager.getFilterAttributes();
			if (filterAtts != null)
				querySettings.filterAttributes = filterAtts;

			progress = this.gridmanager.ds.newProgressIndicator();
			this.gridmanager.setCurProgress(progress);
			querySettings.progressInfo = progress.getRefID();
			querySettings.maxEntities = true;
		}

		let sel;
		let wasAll = false;
		if (queryText == null || queryText === '') {
			wasAll = true;
			sel = this.dataclass.allEntities(querySettings);
		}
		else
			sel = this.dataclass.query(queryText, querySettings);
		if (sel != null) {
			try {
				const len = await sel.getLength();
				if (this.gridmanager != null) {
					this.gridmanager.setCurrentSelection(sel);
				}
				// this.$queryPlanResult.html(JSON.stringify(sel.queryPlan, 4));
				if (wasAll) {
					this.$queryPathResult.html('');
					this.$queryPlanResult.html('');
				} else {
					this.saveQuery(queryText);
					this.buildQueryPlanHTML(sel.extendedQueryPlan);
					this.buildQueryPlanHTML(sel.extendedQueryPath, true);
				}
			}
			catch (err) {
				if (progress == null || !progress.graceFullStop) {
					this.$queryPlanResult.html(`error: ${err.name}, ${err.message}`);
					this.$queryPathResult.html('');
					this.handleExpand(null, true);
				}
			}
		}

	}


	buildValueHTML(value) {
		const manager = this;
		let valueCssClass = 'queryTextElemValue';
		if (value === null || value === undefined) {
			value = 'null';
			valueCssClass = 'queryNullElemValue';
		} else if (value instanceof Date) {
			value = Utils.formatDate(value, 'L');
			valueCssClass = 'queryDateElemValue';
		} else if (typeof (value) === 'object') {
			if (Array.isArray(value))
				valueCssClass = 'queryArrayElemValue';
			else
				valueCssClass = 'queryObjectElemValue';
			value = JSON.stringify(value);
		} else if (typeof (value) === 'boolean') {
			if (value) {
				value = 'true';
			} else
				value = 'false';
			valueCssClass = 'queryBoolElemValue';
		} else if (typeof (value) === 'number') {
			value = Utils.formatNumber(value, { format: '###,###,###,###,###.#####################', overrideGroup: true });
			valueCssClass = 'queryNumberElemValue';
		} else if (typeof (value) === 'string') {
			value = `"${value}"`;
			valueCssClass = 'queryStringElemValue';
		}

		return `<div class="valueLineElem queryPlanSubItem ${valueCssClass}">${value}</div>`;
	}

	// eslint-disable-next-line class-methods-use-this
	buildLevelHTML(level) {
		const html = `<div class="identQueryPlanElem" style="width:${level * 2}em;"> </div>`;
		return html;
	}

	buildQueryPlanElemHTML(queryPlanElem, html, level, isAPath = false) {
		const manager = this;
		// html += this.buildLevelHTML(level);

		let nbrecs;
		let recstr;
		let timeTaken;

		if (isAPath) {
			nbrecs = queryPlanElem.foundRecords;
			recstr = nbrecs < 2 ? 'record' : 'records';
			timeTaken = queryPlanElem.timeTaken;
		}

		const nodeType = queryPlanElem.type;
		if (nodeType === 'LogicOperatorNode') {
			if (queryPlanElem.parts != null) {
				if (queryPlanElem.parts.length === 1) {
					html += manager.buildQueryPlanElemHTML(queryPlanElem.parts[0], '', level, isAPath);
				} else {
					const htmlparts = queryPlanElem.parts.map((part) => {
						return manager.buildQueryPlanElemHTML(part, '', level + 1, isAPath);
					});
					let pathAttr = '';
					if (isAPath) {
						if (timeTaken != null && nbrecs != null)
							pathAttr = `data-timetaken="${timeTaken}" data-recordsfound="${nbrecs}" data-tipstr="${nbrecs} ${recstr} in ${timeTaken} ms"`;
					}
					let subHtml = `<div id="${manager.getNextBlockID()}" ${pathAttr} class="cunjunctionElem queryPlanBlock">`;
					const elemHtml = `<div class="cunjLineElem"> ${manager.buildLevelHTML(level)}<div class="logicOperElem queryPlanSubItem">${queryPlanElem.logicOper}</div></div>`;
					subHtml += htmlparts.join(elemHtml);
					subHtml += '</div>';
					html += subHtml;
				}
			}
		} else if (nodeType === 'IndexNode' || nodeType === 'IndexArrayNode' || nodeType === 'SeqNode' || nodeType === 'SeqEmNode' || nodeType === 'SeqArrayNode') {
			const altclass = queryPlanElem.indexed ? 'indexedLineElem' : 'seqLineElem';
			let subHtml = `<div class="SimpleNodeLineElem queryPlanLine ${altclass}">`;
			subHtml += manager.buildLevelHTML(level);
			if (queryPlanElem.indexed) {
				subHtml += '<div class="indexedItemElem queryPlanSubItem"></div>';
			} else {
				subHtml += '<div class="seqItemElem queryPlanSubItem"></div>';
			}
			let path = queryPlanElem.attributePath;
			if (path == null || path === '') {
				path = queryPlanElem.table;
				if (queryPlanElem.instance !== 0 && queryPlanElem.instance != null)
					path += `(${queryPlanElem.instance})`;
				path += `.${queryPlanElem.field}`;
			} else {
				if (queryPlanElem.instance !== 0 && queryPlanElem.instance != null)
					path += `(${queryPlanElem.instance})`;
			}
			if (queryPlanElem.objectPath != null)
				path += `.${queryPlanElem.objectPath}`;
			let value = queryPlanElem.value;
			if (value == null)
				value = queryPlanElem.value2;
			value = manager.buildValueHTML(value);
			subHtml += `<div class="attLineElem queryPlanSubItem">${path}</div><div class="operLineElem queryPlanSubItem">${queryPlanElem.oper}</div><div class="valueLineElem queryPlanSubItem">${value}</div>`;
			if (queryPlanElem.value !== queryPlanElem.value2 && queryPlanElem.value != null && queryPlanElem.value2 != null) {
				let value2 = queryPlanElem.value2;
				value2 = manager.buildValueHTML(value2);
				subHtml += `<div class="andLineElem queryPlanSubItem">and</div><div class="valueLineElem queryPlanSubItem">${value2}</div>`;
			}
			if (isAPath) {
				if (timeTaken != null && nbrecs != null)
					subHtml += `<div class="infoLineItem queryPlanSubItem">(${nbrecs} ${recstr} in ${timeTaken} ms)</div>`;
			}
			subHtml += '</div>';
			html += subHtml;
		} else if (nodeType === 'JoinNode') {
			let subHtml = `<div id="${manager.getNextBlockID()}" class="joinElem queryPlanBlock">`;

			subHtml += `<div class="joinStartLine"> ${manager.buildLevelHTML(level)}<div class="joinTextElem queryPlanSubItem">Join:</div></div>`;
			subHtml += `<div class="joinLineElem queryPlanLine"> ${manager.buildLevelHTML(level)}`;

			const htmlparts = queryPlanElem.joinPath.map((joincouple) => {
				let leftpath = joincouple.leftTable;
				if (joincouple.leftInstance !== 0) {
					leftpath += `(${joincouple.leftInstance})`;
				}
				leftpath += `.${joincouple.leftField}`;

				let rightpath = joincouple.rightTable;
				if (joincouple.rightInstance !== 0) {
					rightpath += `(${joincouple.rightInstance})`;
				}
				rightpath += `.${joincouple.rightField}`;

				const oper = '==';
				let resultHtml = `<div class="leftJoinCouple queryPlanSubItem">${leftpath}</div>`;
				resultHtml += `<div class="operLineElem queryPlanSubItem">${oper}</div>`;
				resultHtml += `<div class="rightJoinCouple queryPlanSubItem">${rightpath}</div>`;
				return resultHtml;
			});
			const andHtml = '<div class="operLineElem queryPlanSubItem">and</div>';
			subHtml += htmlparts.join(andHtml);
			subHtml += '</div>';

			if (queryPlanElem.filter != null) {
				subHtml += '<div class="filterLineElem">';
				subHtml += '<div class="filterJoinElem queryPlanSubItem">filtered by:</div>';
				subHtml += '</div>';
				subHtml += manager.buildQueryPlanElemHTML(queryPlanElem.filter, '', level + 1, isAPath);
			}

			subHtml += '</div>';
			html += subHtml;
		} else if (nodeType === 'ExistingSelection') {
			let path = queryPlanElem.table;
			if (queryPlanElem.instance !== 0 && queryPlanElem.instance != null)
				path += `(${queryPlanElem.instance})`;
			const altclass = '';
			let subHtml = `<div class="SimpleNodeLineElem queryPlanLine ${altclass}">`;
			subHtml += `<div class="selLineElem queryPlanSubItem">Filtering Selection on: ${path}</div>`;
			subHtml += '</div>';
			html += subHtml;
		}

		return html;
	}

	buildQueryPlanHTML(queryPlan, isAPath = false) {
		const html = queryPlan == null ? '' : this.buildQueryPlanElemHTML(queryPlan, '', 0, isAPath);
		if (isAPath)
			this.$queryPathResult.html(html);
		else
			this.$queryPlanResult.html(html);
	}


}

